<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ActivitiesSeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'tanggal' => date('Y-m-d', strtotime('-30 days')),
                'jam' => '09:00:00',
                'nama_aktivitas' => 'Mengajar di SDIT AL-HIKMAH',
                'deskripsi' => 'Menyusun RPP dan mengajar siswa SD dengan pendekatan pembelajaran yang interaktif dan menyenangkan.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-29 days')),
                'jam' => '14:30:00',
                'nama_aktivitas' => 'Pelatihan AI Dicoding',
                'deskripsi' => 'Mengikuti pelatihan AI untuk meningkatkan pemahaman tentang Artificial Intelligence dan Generative AI.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-28 days')),
                'jam' => '10:00:00',
                'nama_aktivitas' => 'Pengembangan Website Digital Banking',
                'deskripsi' => 'Mengembangkan fitur-fitur perbankan digital menggunakan Laravel dan MySQL.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-27 days')),
                'jam' => '16:00:00',
                'nama_aktivitas' => 'Magang PR di KOMINFO',
                'deskripsi' => 'Mengelola media sosial dan menyebarluaskan informasi program pemerintah kepada masyarakat.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-26 days')),
                'jam' => '11:00:00',
                'nama_aktivitas' => 'Belajar Python Programming',
                'deskripsi' => 'Mempelajari fundamental Python programming melalui platform Dicoding Indonesia.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-25 days')),
                'jam' => '08:00:00',
                'nama_aktivitas' => 'Pengembangan Aplikasi Mobile CV',
                'deskripsi' => 'Membuat aplikasi mobile Android dengan tema pink-peach sakura menggunakan Android Studio.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-24 days')),
                'jam' => '13:00:00',
                'nama_aktivitas' => 'Pelatihan Data Science DQLab',
                'deskripsi' => 'Mengikuti pelatihan Data Science dengan fokus pada Python, R, dan SQL untuk analisis data.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-23 days')),
                'jam' => '15:30:00',
                'nama_aktivitas' => 'Kerja di Store Retail',
                'deskripsi' => 'Melayani pelanggan sebagai cashier dan mengelola transaksi pembayaran tunai/non-tunai.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-22 days')),
                'jam' => '09:30:00',
                'nama_aktivitas' => 'Pengembangan Tempat Sampah Otomatis',
                'deskripsi' => 'Membuat sistem klasifikasi sampah organik dan non-organik menggunakan Machine Learning dan ESP32.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-21 days')),
                'jam' => '14:00:00',
                'nama_aktivitas' => 'Belajar MATLAB',
                'deskripsi' => 'Mengikuti pelatihan MATLAB Onramp dan Control Design dengan Simulink dari MathWorks.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-20 days')),
                'jam' => '10:30:00',
                'nama_aktivitas' => 'Kuliah Ilmu Komputer',
                'deskripsi' => 'Mengikuti perkuliahan di Universitas Yatsi Madani dengan fokus pada Web dan Mobile Development.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-19 days')),
                'jam' => '16:30:00',
                'nama_aktivitas' => 'Administrasi di Laodra Laundry',
                'deskripsi' => 'Mengelola administrasi laundry, pencatatan pesanan, dan meningkatkan efisiensi pelacakan hingga 30%.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-18 days')),
                'jam' => '11:30:00',
                'nama_aktivitas' => 'Pengembangan Website Portofolio',
                'deskripsi' => 'Membuat website portofolio responsif menggunakan HTML, CSS, dan JavaScript.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-17 days')),
                'jam' => '13:30:00',
                'nama_aktivitas' => 'Pelatihan FORTECHBI HIMAKOM',
                'deskripsi' => 'Mengikuti pelatihan tentang ML & AI, studi kasus AI di pendidikan, dan etika pemanfaatan AI.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-16 days')),
                'jam' => '15:00:00',
                'nama_aktivitas' => 'Belajar Data Visualization',
                'deskripsi' => 'Mempelajari teknik visualisasi data dan SQL melalui platform Dicoding Indonesia.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-15 days')),
                'jam' => '09:00:00',
                'nama_aktivitas' => 'Menggunakan Microsoft Office',
                'deskripsi' => 'Membuat dokumentasi teknis dan laporan menggunakan Word, Excel, dan PowerPoint.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-14 days')),
                'jam' => '14:30:00',
                'nama_aktivitas' => 'Belajar Laravel Framework',
                'deskripsi' => 'Mempelajari framework Laravel untuk pengembangan aplikasi web yang lebih efisien.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-13 days')),
                'jam' => '10:00:00',
                'nama_aktivitas' => 'Praktik Problem Solving',
                'deskripsi' => 'Mengasah kemampuan problem solving melalui studi kasus dan project development.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-12 days')),
                'jam' => '16:00:00',
                'nama_aktivitas' => 'Teamwork Project',
                'deskripsi' => 'Berkolaborasi dalam tim untuk mengembangkan project teknologi dengan manajemen waktu yang baik.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d', strtotime('-11 days')),
                'jam' => '11:00:00',
                'nama_aktivitas' => 'Belajar Kotlin Dasar',
                'deskripsi' => 'Mempelajari dasar-dasar pemrograman Kotlin untuk pengembangan aplikasi Android.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal' => date('Y-m-d'),
                'jam' => '08:00:00',
                'nama_aktivitas' => 'Update CV dan Portfolio',
                'deskripsi' => 'Memperbarui CV dan portfolio dengan project dan pengalaman terbaru.',
                'foto' => null,
                'video' => null,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        $this->db->table('activities')->insertBatch($data);
    }
}

